// SPDX-License-Identifier: GPL-2.0


/* Konfiguration des AVR:
 * - Lautsprecher an C2 (und GND)
 * - Sekunden-LED an C0
 * - DEBUG-LED    an C1
 * 
 * 
 * */

#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/init.h>

#include <asm/rodata.h>
#include <asm/gpio.h>


#define DEBUG

#ifdef DEBUG
#define DEBUG_TOGGLE() do { gpio_toggle(GPIO_C1); } while(0)
#else
#define DEBUG_TOGGLE() do { } while(0)
#endif



void _add_timer(struct timer *timer);

static struct timer song_timer, ton_timer;

#ifdef DEBUG
static struct timer sekunden_timer;

static void sekunden_callback(struct timer *timer) {
	gpio_toggle(GPIO_C0);
	timer->expires += HZ;
	_add_timer(timer);
}
static struct timer sekunden_timer = {
	.function = sekunden_callback,
	.expires  = HZ,
};
#endif /* DEBUG */


#define OKTAVE  2
#define FREQ(x) (HZ / x / OKTAVE)

#define C1	FREQ(262)
#define Cis1	FREQ(277)
#define D1	FREQ(294)
#define Dis1	FREQ(311)
#define E1	FREQ(330)
#define F1	FREQ(349)
#define Fis1	FREQ(370)
#define G1	FREQ(392)
#define Gis1	FREQ(415)
#define A1	FREQ(440)
#define Ais1	FREQ(466)
#define H1	FREQ(494)
#define C2	FREQ(523)

#define Cis2	FREQ(554)
#define D2	FREQ(587)
#define Dis2	FREQ(622)
#define E2	FREQ(659)
#define F2	FREQ(698)
#define Fis2	FREQ(740)
#define G2	FREQ(784)
#define Gis2	FREQ(831)


#define ACHTEL      (HZ/8)
#define DREIACHTEL  (HZ*3/8)
#define VIERTEL     (HZ/4)
#define DREIVIERTEL (HZ*3/4)
#define HALB        (HZ/2)
#define GANZ        (HZ)
#define TON_PAUSE   (HZ/32)

#define PAUSE   0


//C D E F G G A A A A G
typedef u32 dauer_t;
typedef u16 ton_t;
struct note_t {
	dauer_t dauer;
	ton_t   ton;
	u8  keinepause;
};

static struct note_t __rodata alle_meine_entchen[] = {
/*    Al      -      le               Mei             ne             Ent    -    chen     */
{ VIERTEL, D1 }, { VIERTEL, E1 }, { VIERTEL, Fis1 }, { VIERTEL, G1 }, { HALB, A1 }, { HALB, A1 },
/*   schim    -     men               auf             dem            See                  */
{ VIERTEL, H1 }, { VIERTEL, H1 }, { VIERTEL, H1 }, { VIERTEL, H1 }, { HALB, A1 }, { HALB, PAUSE },
/*   schim    -     men               auf             dem            See                  */
{ VIERTEL, H1 }, { VIERTEL, H1 }, { VIERTEL, H1 }, { VIERTEL, H1 }, { HALB, A1 }, { HALB, PAUSE },
/*   Kpf     -     chen              in              das            Was      -   ser     */
{ VIERTEL, G1 }, { VIERTEL, G1 }, { VIERTEL, G1 }, { VIERTEL, G1 }, { HALB, Fis1 }, { HALB, Fis1 },
/*   Schwnz  -       chen            in             die              Hh'              */
{ VIERTEL, A1 }, { VIERTEL, A1 }, { VIERTEL, A1 }, { VIERTEL, A1 }, { HALB, D1}, { HALB, PAUSE },
{ GANZ, PAUSE }
};

static struct note_t __rodata happy_birthday[] = {
/*                       Hap        -        py      */
{ VIERTEL, PAUSE }, { VIERTEL, D1, 1 }, { VIERTEL, D1 }, 
/* Birth            day                 to   */
{ VIERTEL, E1 }, { VIERTEL, D1 }, { VIERTEL, G1 },
/*  you              Hap              py         */
{ HALB, F1 }, { VIERTEL, D1, 1 }, { VIERTEL, D1 },
/*  Birth           day              to       */
{ VIERTEL, E1 }, {VIERTEL, D1}, { VIERTEL, A1},
/*  you             Hap                 py        */
{ HALB, G1 }, { VIERTEL, D1, 1}, { VIERTEL, D1},
/*   Birth           day              lie             ber */
{ VIERTEL, D2 }, { VIERTEL, H1}, { VIERTEL, G1, 1}, { VIERTEL, G1},
/*     x                y              Hap                 py */
{ VIERTEL, E1 }, { VIERTEL, D1}, { VIERTEL, A1, 1}, { VIERTEL, A1},
/* Birth             day                  to     */
{ VIERTEL, H1 }, { VIERTEL, G1 }, { VIERTEL, A1 },
/*  you  */
{ HALB, G1 },
{ GANZ, PAUSE },
};

static struct note_t __rodata fuchs_du_hast_die_gans_gestohlen[] = {
/*    Fuchs,         du            hast              die          Ganz            ge       -     stoh      -      len,     */
{ VIERTEL, D1, 1 }, { VIERTEL, E1 }, { VIERTEL, F1, 1 }, { VIERTEL, G1 }, { VIERTEL, A1 , 1}, { VIERTEL, A1 }, { VIERTEL, A1 , 1}, { VIERTEL, A1 },
/*   gib            sie              wie       -      der            her,                                     gib              sie          wie         -       der        */
{ VIERTEL, H1, 1 }, { VIERTEL, G1 }, { VIERTEL, D2, 1 }, { VIERTEL, H1 }, { DREIVIERTEL, A1 }, { VIERTEL, PAUSE }, { VIERTEL, H1, 1 }, { VIERTEL, G1 }, { VIERTEL, D2, 1 }, { VIERTEL, H1 },
/*  her,                                       Sonst               wird            dich               der               J            -         ger            ho          -      len   */
{ DREIVIERTEL, A1 }, { VIERTEL, PAUSE }, { VIERTEL, A1, 1 }, { VIERTEL, G1 }, { VIERTEL, G1, 1 }, { VIERTEL, G1 }, { VIERTEL, G1, 1 },  { VIERTEL, F1 }, { VIERTEL, F1, 1 }, { VIERTEL, F1 },
/*       mit             dem             Schie-             ge          -       we         -          e          -     ehr  */
{ VIERTEL, F1, 1 }, { VIERTEL, E1 }, { VIERTEL, F1, 1 }, { VIERTEL, E1 }, { VIERTEL, D1, 1}, { VIERTEL, F1, 1 }, { VIERTEL, A1 }, { VIERTEL, PAUSE },
/*    Sonst               wird            dich               der               J            -         ger            ho          -      len   */
{ VIERTEL, A1, 1 }, { VIERTEL, G1 }, { VIERTEL, G1, 1 }, { VIERTEL, G1 }, { VIERTEL, G1, 1 },  { VIERTEL, F1 }, { VIERTEL, F1, 1 }, { VIERTEL, F1 },
/*       mit             dem             Schie-             ge          -       we         -          e          -     ehr  */
{ VIERTEL, F1, 1 }, { VIERTEL, E1 }, { VIERTEL, F1, 1 }, { VIERTEL, E1 }, { DREIVIERTEL, D1 }, { VIERTEL, PAUSE },

{ GANZ, PAUSE }
};

static struct note_t __rodata o_du_froehliche[] = {
	/*    O           du             frh   -            li            -                che,                 O             du            se          -       li            -           ge    */
	{ HALB, G1 }, { HALB, A1 }, { DREIACHTEL, G1 }, { ACHTEL, F1 }, { VIERTEL, E1 , 1}, { VIERTEL, F1 }, { HALB, G1}, { HALB, A1 }, { DREIACHTEL, G1 }, { ACHTEL, F1 }, { HALB, E1, 1 }, { HALB, F1 },
	/*  gna       -     den    -    brin    -    gen        -       de             Weih     -    nachts     -  Zeit */
	{ HALB, G1 }, { HALB, G1 }, { HALB, A1 }, { VIERTEL, H1 }, { VIERTEL, C2 }, { HALB, H1 }, { HALB, A1 }, { GANZ, G1 },
	/*                     Welt                 ging              ver     -                        lo             -     ren,                            Christ               ward             ge                -           bo             -        ren:  */
	{ DREIACHTEL, D1, 1 }, { ACHTEL, E1 }, { VIERTEL, D1 }, { VIERTEL, E1 }, { DREIACHTEL, F1, 1 }, { ACHTEL, G1 }, { HALB, F1 },  { DREIACHTEL, E1 , 1}, { ACHTEL, F1 }, { VIERTEL, E1 }, { VIERTEL, F1 }, { DREIACHTEL, G1 }, { ACHTEL, A1 }, { HALB, G1 },
	/*                Freu              -                   e                      freu      -       e                dich,         O            Chri     -       sten        - heit  */
	{ VIERTEL, C2, 1 }, { VIERTEL, H1 }, { VIERTEL, A1, 1 }, { VIERTEL, G1 }, { VIERTEL, C2 }, { VIERTEL, A1 }, { VIERTEL, G1 }, { VIERTEL, F1 }, { HALB, E1 }, { HALB, D1 }, { GANZ, C1 },
	
	{ GANZ, PAUSE }
};

static struct note_t __rodata leise_rieselt_der_schnee[] = {
	/*     Lei    -     se                 rie     -       selt           der                            Schnee    */
	{ HALB, H1, }, { VIERTEL, H1 }, { VIERTEL, A1 }, { VIERTEL, H1 }, { VIERTEL, A1 }, { DREIVIERTEL, G1 }, { HALB, G1 , 1}, { VIERTEL, PAUSE },
	/*  still            und              starr            ruht             der                          See    */
	{ HALB, G1 }, { VIERTEL, E1 }, { VIERTEL, G1 }, { VIERTEL, Fis1 }, { VIERTEL, E1 }, { DREIVIERTEL, D1 }, { HALB, D1 }, { VIERTEL, PAUSE },
	/* weih        -     nacht                 lich            gln           zet               der                         Wald:      */
	{ VIERTEL, A1 }, { VIERTEL, Gis1 }, { VIERTEL, A1 }, { VIERTEL, C2 }, { VIERTEL, H1 }, { VIERTEL, A1 }, { DREIVIERTEL, G1 },  { HALB, G1 }, { VIERTEL, PAUSE },
	/*      Freu      -       e                dich,         Christ             kind              kommt                          bald!  */
	{ DREIACHTEL, A1 }, { ACHTEL, E1 }, { VIERTEL, E1 }, { VIERTEL, Fis1 }, { VIERTEL, E1, 1}, { VIERTEL, Fis1 }, { DREIVIERTEL, G1 }, { HALB, G1 }, { VIERTEL, PAUSE },
	
	{ GANZ, PAUSE },
};





#undef ACHTEL
#undef DREIACHTEL
#undef VIERTEL
#undef DREIVIERTEL
#undef HALB
#undef GANZ

#define ACHTEL      (HZ/4)
#define DREIACHTEL  (HZ*3/4)
#define VIERTEL     (HZ/2)
#define DREIVIERTEL (HZ*3/2)
#define HALB        (HZ)
#define GANZ        (HZ*2)


static struct note_t __rodata schneefloeckchen[] = {
	/*    Schne            e      |   flk               chen                Wei            rck     -    chen,                     wann                   kommst                du           ge        -      schneit                du       */
	{ ACHTEL, A1 }, { ACHTEL, H1 }, { VIERTEL, C2 }, { VIERTEL, C2 }, { VIERTEL, D2 }, { VIERTEL, G1 }, { VIERTEL, G1}, { ACHTEL, G1 }, { ACHTEL, A1 }, { VIERTEL, H1 }, { VIERTEL, H1 }, { VIERTEL, C2 }, { HALB, A1 }, { ACHTEL, A1 }, { ACHTEL, H1 },
	/*  wohnst               in          den               Wol        -      ken                      dein                    Weg                ist             so             weit */
	{ VIERTEL, C2 }, { VIERTEL, C2 }, { VIERTEL, F2 }, { VIERTEL, E2 }, { VIERTEL, D2 }, { ACHTEL, C2 }, { ACHTEL, H1 }, { VIERTEL, A1 }, { VIERTEL, H1 }, { VIERTEL, G1 }, { GANZ, F1 },
	
	{ GANZ, PAUSE }
};

static struct note_t __rodata schneefloeckchen2[] = {
	/*    Schne                e      |   flk               chen                Wei            rck     -    chen,                        wann                   kommst                du           ge        -      schneit                   du       */
	{ ACHTEL, A1 , 1 }, { ACHTEL, H1 }, { VIERTEL, C2 }, { VIERTEL, C2 }, { VIERTEL, D2 }, { VIERTEL, G1 }, { VIERTEL, G1}, { ACHTEL, G1, 1 }, { ACHTEL, A1 }, { VIERTEL, H1 }, { VIERTEL, H1 }, { VIERTEL, C2 }, { HALB, A1 }, { ACHTEL, A1, 1 }, { ACHTEL, H1 },
	/*  wohnst               in          den               Wol        -      ken                         dein                    Weg                ist             so             weit */
	{ VIERTEL, C2 }, { VIERTEL, C2 }, { VIERTEL, F2 }, { VIERTEL, E2 }, { VIERTEL, D2 }, { ACHTEL, C2, 1 }, { ACHTEL, H1 }, { VIERTEL, A1 }, { VIERTEL, H1 }, { VIERTEL, G1 }, { GANZ, F1 },
	
	{ GANZ, PAUSE }
};




#define ADD_SONG(x)  { x, ARRAY_SIZE(x) }
struct song_t {
	const struct note_t __rodata *song;
	unsigned char length;
};

static struct song_t __rodata songs[] = {
	ADD_SONG(happy_birthday),
	ADD_SONG(alle_meine_entchen),
	ADD_SONG(fuchs_du_hast_die_gans_gestohlen),
	ADD_SONG(leise_rieselt_der_schnee),
	ADD_SONG(leise_rieselt_der_schnee),
	ADD_SONG(schneefloeckchen),
	ADD_SONG(schneefloeckchen2),
	ADD_SONG(o_du_froehliche),
};

const struct note_t __rodata *song;
unsigned int song_length;
int song_id = 0;


static ton_t song_ton = 0;
static s8 song_pos = 0;
static u8 ton_pause = 1;

static void song_callback(struct timer *timer) {

	if (ton_pause) {
		dauer_t dauer;
		ton_t alter_ton = song_ton;
		/* Rckkehr von der Pause */
		song_ton = song[song_pos].ton;
		dauer = song[song_pos].dauer;
		/* Normalerweise sollten wir hier auch schon den Ausgang flippen */
		ton_timer.expires = timer->expires + song_ton;
		if (alter_ton != 0 && ton_pause == 2) {
			if (song_ton == 0) {
				DEBUG_TOGGLE();
				del_timer(&ton_timer);
			}
		} else if (song_ton != 0) {
			DEBUG_TOGGLE();
			_add_timer(&ton_timer);
		}
		if (!song[song_pos].keinepause) {
			timer->expires -= TON_PAUSE;
			ton_pause = 0;
		} else {
			ton_pause = 2;
		}
		timer->expires += dauer;

		/* Lied zuende? */
		if (song_pos == song_length - 1) {
			song_pos = 0;
			song_id ++;
			if (song_id == ARRAY_SIZE(songs))
				song_id = 0;
			song = songs[song_id].song;
			song_length = songs[song_id].length;
		} else
			song_pos++;
	} else {
		/* Rckkehr vom Ton */
		ton_pause = 1;
		if (song_ton != 0) {
			DEBUG_TOGGLE();
			del_timer(&ton_timer);
		}
		timer->expires += TON_PAUSE;
	}
	_add_timer(timer);
}
static struct timer song_timer = {
	.function = song_callback,
	.expires  = HZ * 2,
};

static void ton_callback(struct timer *timer) {
	gpio_toggle(GPIO_C2);
	timer->expires += song_ton;
	_add_timer(timer);
}
static struct timer ton_timer = {
	.function = ton_callback,
	.expires  = HZ + 1 + HZ / 880,
};



static int init_song(void) {
	gpiogroup_set_output_v(GPIO_C0, GPIO_C0_NBITS, 7);
	gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, 0);

	song = songs[0].song;
	song_length = songs[0].length;
	
	add_timer(&song_timer);
#ifdef DEBUG
	add_timer(&sekunden_timer);
#endif
	return 0;
}

initcall(init_song);
