// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2017-2019 Rupert Eibauer. All rights reserved.

#include <linux/timer.h>
#include <linux/sched.h>
#include <linux/task.h>
#include <linux/printk.h>
#include <linux/init.h>

#include <asm/system.h>
#include <asm/gpio.h>

//#define NO_WAIT
#ifdef NO_WAIT

#define wait() do { } while(0)

#else /* NO_WAIT */
static void wait(void) {
	volatile int wait_counter;
	volatile int wait_counter2;
	for (wait_counter = 0; wait_counter < 1000; wait_counter++)
	for (wait_counter2 = 0; wait_counter2 < 1000; wait_counter2++);
}
#endif /* NO_WAIT */

/* Simple completion test */
/* The result should look like the following (when watched with simulavr-disp)
   PORTB alternating between 1 and 2
*/

struct completion s;
#ifdef CONFIG_STACK_SIZE_FIXED
struct task_struct tw;
#endif
__kthread_func void fw(void *arg)
{
	for (;;)
	{
		gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, 1);
		wait();
		wait_for_completion(&s);
		printf("a\n");
	}
}

static struct timer test_timer;
static void timer_callback(struct timer *timer) {
	gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, 2);
	complete_from_irq(&s);
	printf("Timer\n");
#ifdef CONFIG_DEL_TIMER
	mod_timer(timer, test_timer.expires + HZ);
#else
	test_timer.expires += HZ;
	add_timer(timer);
#endif
	
}
static struct timer test_timer = {
	.function = timer_callback,
	.expires  = HZ + 1 + HZ,
};

static int init_semaphore_timer_test(void) {
	int i;

	printk(KERN_NOTICE "HELLO WORLD!\n");
	gpiogroup_set_output(GPIO_B0, GPIO_B0_NBITS, 0x3f);
	local_irq_enable();
	add_timer(&test_timer);
	wait();
	wait();
	wait();
	wait();
	gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, 7);
	for (i = 0; i <= 7; i++) {
		wait();
		gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, i);
	}
	wait();
	gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, 0);

#ifdef CONFIG_STACK_SIZE_FIXED
	kernel_thread(&tw, fw, NULL, 2); /* High-prio waiter */
#else
	kernel_thread(128, fw, NULL, 2); /* High-prio waiter */
#endif
	gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, 1);
	printk(KERN_NOTICE "calling schedule!\n");
	return 0;
}

initcall(init_semaphore_timer_test);
