// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2017-2019 Rupert Eibauer. All rights reserved.

#include <linux/init.h>
#include <linux/sched.h>
#include <linux/task.h>

#include <asm/io.h>
#include <asm/system.h>
#include <asm/gpio.h>


//#define NO_WAIT
#ifdef NO_WAIT

#define wait() do { } while(0)

#else /* NO_WAIT */
static void wait(void) {
	volatile int wait_counter;
	volatile int wait_counter2;
	for (wait_counter = 0; wait_counter < 50; wait_counter++)
	for (wait_counter2 = 0; wait_counter2 < 1000; wait_counter2++);
}
#endif /* NO_WAIT */

#ifdef CONFIG_STACK_SIZE_FIXED
struct task_struct o1;
struct task_struct o2;
#endif

__kthread_func void fo1(void *arg) {
	for (;;) {
		wait();
		gpio_toggle(GPIO_B0);
	}
}
__kthread_func void fo2(void *arg) {
	for (;;) {
		wait();
		gpio_toggle(GPIO_B1);
	}
}

static int init_sched_other_test(void) {
	int i;

	gpiogroup_set_output_v(GPIO_B0, GPIO_B0_NBITS, 0x3f);
	wait();
	wait();
	wait();
	wait();
	gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, 7);
	for (i = 0; i <= 7; i++) {
		wait();
		gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, i);
	}
	wait();
	gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, 0);

#ifdef CONFIG_STACK_SIZE_FIXED
	kernel_thread(&o1, fo1, NULL, -1);
	kernel_thread(&o2, fo2, NULL, -2);
#else
	kernel_thread(128, fo1, NULL, -1);
	kernel_thread(128, fo2, NULL, -2);
#endif

	gpiogroup_out(GPIO_B0, GPIO_B0_NBITS, 1);
	return 0;
}

initcall(init_sched_other_test);
