#!/bin/bash
# SPDX-License-Identifier: GPL-2.0
#
# link rupsched

if [ "$1" = "clean" ]; then
	rm -f progmem.bin fmtstr.map lib/printf_config.h
	exit 0
fi

. ./.config

# echo "link-rupsched.sh called!"
# echo KBUILD_VMLINUX_INIT=$KBUILD_VMLINUX_INIT
# echo KBUILD_VMLINUX_MAIN=$KBUILD_VMLINUX_MAIN
# echo KBUILD_VMLINUX_LIBS=$KBUILD_VMLINUX_LIBS
# echo kallsymso=$kallsymso
# echo objects=$objects
# echo KBUILD_LDFLAGS=$KBUILD_LDFLAGS
# echo LDFLAGS_rupsched=$LDFLAGS_rupsched
# echo LD=$LD
# echo CC=$CC
KBUILD_c_flags="${KBUILD_CPPFLAGS} ${KBUILD_CFLAGS} ${LINUXINCLUDE}"


V=0
if [ "$quiet" = "" ]; then
	V=1
fi

exit_if_fail() {
	local v=$?
	
	if [ "$1" != "" ]; then
		v=$1
	fi
	if [ $v = 0 ]; then
		return
	fi
	echo "link-rupsched.sh failed" >&2
	exit 1
}

symbol_defined() {
	local mode=$1
	local sym=$2
	return $(nm rupsched-1.o | (grep -q " $mode $sym"; echo $?))
}


build_command() {
	msg="$1"
	shift
	if [ $V = 1 ]; then
		echo "$@"
	else
		echo "$msg"
	fi
	$@
	exit_if_fail
}
build_ld() {
	target="$1"
	shift
	msg="  LD      $target"
	if [ $V = 1 ]; then
		echo "${CC} -o $target $@"
	else
		echo "$msg"
	fi
	${CC} -o $target $@ >.$target.warning 2>&1
	status=$?
	cat .$target.warning | grep -v "warning: -z relro ignored" >&2
	rm .$target.warning
	exit_if_fail $status
}
build_cc() {
	target="$1"
	shift
	msg="  CC      $target"
	source=${target:0:-2}.c
	if [ $V = 1 ]; then
		echo "${CC} ${KBUILD_c_flags} -c -o $target $source"
	else
		echo "$msg"
	fi
	${CC} ${KBUILD_c_flags} -c -o $target $source
	exit_if_fail
}
build_ar() {
	target="$1"
	shift
	msg="  AR      $target"
	if [ $V = 1 ]; then
		echo "${AR} rcSTP${KBUILD_ARFLAGS} $target $@"
	else
		echo "$msg"
	fi
	rm -f $target
	${AR} rcSTP${KBUILD_ARFLAGS} $target $@
	exit_if_fail
	if [ $V = 1 ]; then
		echo "${ARCH}-ranlib $target"
	fi
	${ARCH}-ranlib $target
	exit_if_fail
}

build_ar_add() {
	target="$1"
	shift
	msg="  AR      $target"
	if [ $V = 1 ]; then
		echo "${AR} rcSTP${KBUILD_ARFLAGS} $target $@"
	else
		echo "$msg"
	fi
	${AR} rcSTP${KBUILD_ARFLAGS} $target $@
	exit_if_fail
	if [ $V = 1 ]; then
		echo "${ARCH}-ranlib $target"
	fi
	${ARCH}-ranlib $target
	exit_if_fail
}

# find out the linker arch

objects="-Wl,--whole-archive $KBUILD_VMLINUX_INIT $KBUILD_VMLINUX_MAIN -Wl,--no-whole-archive $KBUILD_VMLINUX_LIBS"

#rupsched-1.o is needed for a few things here.
build_ld rupsched-1.o ${KBUILD_LDFLAGS} ${LDFLAGS_rupsched} -r ${objects}

LATE_OBJS=""

# Build lib/vdevprintf.o
if symbol_defined U vdevprintf; then
	build_command "  OBJCOPY progmem.bin" ${OBJCOPY} -j .progmem.data -O binary rupsched-1.o progmem.bin
	build_command "  GEN     fmtstr.map" nm rupsched-1.o | grep "r __fmtstr" >fmtstr.map
	build_command "  GEN     lib/printf_config.h" php lib/gen_printf_config.php fmtstr.map progmem.bin lib/printf_config.h
	build_cc lib/vdevprintf.o
#	build_ar_add lib/lib.a lib/vdevprintf.o
	LATE_OBJS="lib/vdevprintf.o $LATE_OBJS"
fi
# Build arch/avr/kernel/head.o
# Make sure hard irqs get included in the printf config
# CONFIG_IRQ_COMMON := $
if [ -f arch/${SRCARCH}/scripts/prelink-script.sh ]; then
. arch/${SRCARCH}/scripts/prelink-script.sh
fi

build_ld rupsched.o ${KBUILD_LDFLAGS} ${LDFLAGS_rupsched} $LATE_OBJS ${objects}
