// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2017-2019 Rupert Eibauer. All rights reserved.

#ifdef TEST

#include <stdint.h>
#define s16 int16_t
#define u8 uint8_t
#include <stdio.h>
#define __rodata const

#else

#include <linux/types.h>
#include <asm/rodata.h>

#endif

#define QUADRANT_SIZE 90

static u8 __rodata SINUS_QUADRANT1[QUADRANT_SIZE + 1] = {
#include "sin_9.h"
};

s16 sin_9(u16 deg) {
	s16 retval;

	if (deg <= QUADRANT_SIZE) {
		retval = SINUS_QUADRANT1[(u8)deg];
	} else if (deg <= QUADRANT_SIZE * 2) {
		retval = SINUS_QUADRANT1[(u8)(QUADRANT_SIZE * 2 - deg)];
	} else if (deg <= QUADRANT_SIZE * 3) {
		retval = -SINUS_QUADRANT1[(u8)(deg - QUADRANT_SIZE * 2)];
	} else {
		retval = -SINUS_QUADRANT1[(u8)(QUADRANT_SIZE * 4 - deg)];
	}
	return retval;
}

#ifdef TEST
int main(void) {
	int i;
	for (i = 0; i <= QUADRANT_SIZE * 4; i++) {
		printf("sin9(%d) = %d\n", i, sin_9(i));
	}
	return 0;
}
#endif
