// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2018 Rupert Eibauer. All rights reserved.

#define short_mul_asm_mac(a_, b_) ({ \
	unsigned int a = a_; \
	unsigned int b = b_; \
	unsigned int ret; \
	asm(   "mul	%A[a], %A[b] ; r0:r1 = tmp[0] * b[0]" \
	"\n	movw	%A[ret], r0  ; a = r0:r1" \
	"\n	mul	%A[a], %B[b] ; r0:r1 = tmp[0] * b[1]" \
	"\n	add	%B[ret], r0  ; a[1] += r0" \
	"\n	mul	%B[a], %A[b] ; r0:r1 = tmp[1] * b[0]" \
	"\n	add	%B[ret], r0  ; a[1] += r0" \
	"\n	clr	r1"  /* clobber Wirkungslos! */          \
	: [ret]"=&w"(ret) \
	: [a]"w"(a), [b]"w"(b) \
	: "r0", "r1"); \
	ret; \
})

unsigned int short_mul(unsigned int a, unsigned int b) {
  return a * b;
}
unsigned int short_mul_mac(unsigned int a, unsigned int b) {
  return short_mul_asm_mac(a, b);
}
unsigned int short_add(unsigned int a, unsigned int b) {
  return a + b;
}
unsigned int short_add1(unsigned int a) {
  return a + 1;
}
/*
r0:r1 = a[1] * b[0]
ret = r0:r1
r0:r1 = a[0] * b[1]
ret += r0:r1
r0:r1 = a[1] * b[1]
ret[1] += r1
*/

#define U16_MUL_DOUBLE_c(u16, dbl) mul_u16_div_256_c(u16, (int)(256. * dbl))
static inline unsigned int mul_u16_div_256_c(unsigned int a, unsigned int b) {
	unsigned int ret;
	ret  = ((a & 0xff) * (b & 0xff)) >> 8;
	ret += (a >> 8) * (b & 0xff);
	ret += (a & 0xff) * (b >> 8);
	ret += ((b >> 8) * (a >> 8)) << 8;
	return ret;
}

#define U16_MUL_DOUBLE(u16, dbl) mul_u16_div_256(u16, (int)(256. * dbl))
#define mul_u16_div_256(a_, b_) ({                            \
	unsigned int a = a_;                                  \
	unsigned int b = b_;                                  \
	unsigned int ret;                                     \
	asm(   "mul	%B[a], %A[b] ; ret = a[1] * b[0]"     \
	"\n	movw	%[ret],  r0"                          \
	"\n	mul	%A[a], %B[b] ; ret += a[0] * b[1]"    \
	"\n	add	%A[ret], r0"                          \
	"\n	adc	%B[ret], r1"                          \
	"\n	mul	%A[a], %A[b] ; ret += (a[0] * b[0]) >> 8"  \
	"\n	add	%A[ret], r1"                          \
	"\n	clr	r1"                                   \
	"\n	adc	%B[ret], r1"                      \
	"\n	mul	%B[a], %B[b] ; ret[1] += (a[1] * b[1])"  \
	"\n	add	%B[ret], r0"                          \
	"\n	clr	r1"  /* clobber Wirkungslos! */       \
	: [ret]"=&w"(ret)                                     \
	: [a]"w"(a), [b]"w"(b)                                \
	: "r0", "r1");                                        \
	ret;                                                  \
})
unsigned int berechne_cV(unsigned int a) {
	return U16_MUL_DOUBLE(a, 0.488759);
}
unsigned int berechne_cV_c(unsigned int a) {
	return U16_MUL_DOUBLE_c(a, 0.488759);
}

