// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2010, 2017-2019 Rupert Eibauer. All rights reserved.

#ifdef TEST

#include <stdint.h>
#define u16 uint16_t
#define s16 int16_t
#define u8 uint8_t
#define s8 int8_t
#include <stdio.h>
#define __rodata

#include "byte_tables/createTable.h"

#else

#include <linux/types.h>
#include <rupsched/byte_table.h>
#include <asm/rodata.h>

#endif

#ifdef CONFIG_BYTE_TABLE_BOUNDS_CHECK
#define bounds_check(x) (x)
#else
#define bounds_check(x) 1
#endif

#define compensate(x) (x)
//#define compensate(x)  0

s16 bt_rconv(struct byte_table *bt, s16 y_target) {
	s16 x = bt->x;
	s16 y = bt->y;
	s16 d1 = bt->d1;
	s16 y_offset;

	while (y + d1 < y_target && bounds_check(x + 1 < bt->n_values)) {
		y += d1;
		d1 += (s8)bt->d2[x];
		x++;
	}
	while(y > y_target && bounds_check(x >= 0)) {
		x--;
		d1 -= (s8)bt->d2[x];
		y -= d1;
	}
	bt->y = y;
	bt->x = x;
	bt->d1 = d1;

	y_offset = y_target - y;
	return bt->x0 + x * bt->step_width + (y_offset * bt->step_width + compensate(d1/2)) / d1;
}

s16 bt_conv(struct byte_table *bt, s16 x_target) {
	s16 x = bt->x;
	s16 x_t = (x_target - bt->x0) / bt->step_width;
	s16 x_offset;
	s16 y = bt->y;
	s16 d1 = bt->d1;

	while (x < x_t && bounds_check(x + 1 < bt->n_values)) {
		y += d1;
		d1 += (s8)bt->d2[x];
		x++;
	}
	while(x > x_t && bounds_check(x > 0)) {
		x--;
		d1 -= (s8)bt->d2[x];
		y -= d1;
	}
	bt->y = y;
	bt->x = x;
	bt->d1 = d1;

	x_offset = x_target - bt->x0 - x * bt->step_width;
	return y + (x_offset * d1 + compensate(bt->step_width / 2)) / bt->step_width;
}
