<?php

$kconfig = '';
$makefile = '';
$kconfig .= "menu \"Register layout\"\n\n";

$counter_used_defs = '';
$counter_saved_defs = '';
$counter_used = '';
$counter_saved = '';

$texts = [
	26 => "Beware: The X pointer is used in some compiler built-ins\nCheck rupsched.dump for r26 use.\nYou may have to rewrite compiler built-ins to use another register or save and restore X",
	27 => "Beware: The X pointer is used in some compiler built-ins\nCheck rupsched.dump for r26 use.\nYou may have to rewrite compiler built-ins to use another register or save and restore X",
	28 => "Beware: The compiler always uses Y in varargs functions,\nno matter if we reserve it or not!\nThe compiler will not honor -ffixed-r28 in other occasions.",
	29 => "Beware: The compiler always uses Y in varargs functions,\nno matter if we reserve it or not!\nThe compiler will not honor -ffixed-r29 in other occasions.",
	30 => "Beware: The Z pointer is needed for FLASH access and indirect calls!",
	31 => "Beware: The Z pointer is needed for FLASH access and indirect calls!!",
];

/*
 * FIXME: When Z is call-saved the compiler produces garbage:
 * push r30
 * push r31
 * pop r31
 * pop r30
 * ijmp
 * The correct code to place this indirect call would be:
 * movw 26, r24
 * ld r20, X+
 * ld r21, X
 * push r20
 * push r21
 * ret
 */

for ($r = 2; $r < 32; $r++) {
	if ($r < 18 || $r == 28 || $r == 29)
		$default = "CALL_SAVED";
	else
		$default = "CALL_USED";
	$spc = ($r < 10) ? ' ' : '';

	$attention = isset($texts[$r]) ? " Beware (see help)" : '';
	$kconfig_r = "choice\n\tprompt \"R$r$attention\"\n\tdefault ${default}_R$r\n";
	if (isset($texts[$r])) {
		$kconfig_r .= "\thelp\n";
		$kconfig_r .= implode("\n\t  ", explode("\n", $texts[$r]));
	}
	$kconfig_r .= "\n";

	if ($default == "CALL_USED") {
		$kconfig_r .= "config CALL_USED_R$r\n\tbool \"Call-Clobbered\"\n\n";
		if ($r < 30) {
			// For some reason it doesn't boot!
			$kconfig_r .= "config CALL_SAVED_R$r\n\tbool \"Call-Saved\"\n\n";
			$makefile .= "cflags-$(CONFIG_CALL_SAVED_R$r)$spc += -fcall-saved-r$r\n";
		}
	} else {
		$kconfig_r .= "config CALL_SAVED_R$r\n\tbool \"Call-Saved\"\n\n";
		if ($r != 28 && $r != 29) {
			 // Compiler error: cannot use 'r28' as a call-used register
			$kconfig_r .= "config CALL_USED_R$r\n\tbool \"Call-Clobbered\"\n\n";
			$makefile .= "cflags-$(CONFIG_CALL_USED_R$r)$spc  += -fcall-used-r$r\n";
		}
	}
	/* We don't reserve r19-r25 these registers because
	 * they are needed for function arguments. (We have at 
	 * most 4 arguments to a function), and this is kernel_thread. */
	if (($r < 18 || $r > 25) && $r < 30) {
		// The compiler always uses Y in varargs functions, no matter if we reserve it or not!
		// Maybe make it dependent on config_printf?
		$kconfig_r .= "config RESERVED_R$r\n\tbool \"Reserved\"\n\n";
		$makefile .= "cgflags-$(CONFIG_RESERVED_R$r)$spc   += -ffixed-r$r\n";
	}
	$kconfig_r .= "endchoice\n\n";
	if ($r != 28 && $r != 29) {
		// Compiler error: cannot use 'r28' as a call-used register
		$counter_used_defs .= "#ifdef CONFIG_CALL_USED_R$r\n#define CNTU_R$r 1\n#else\n#define CNTU_R$r 0\n#endif\n";
		if ($counter_used != '')
			$counter_used .= ' + ';
		$counter_used .= "CNTU_R$r";
	}
	$counter_saved_defs .= "#ifdef CONFIG_CALL_SAVED_R$r\n#define CNTS_R$r 1\n#else\n#define CNTS_R$r 0\n#endif\n";
	if ($counter_saved != '')
		$counter_saved .= ' + ';
	$counter_saved .= "CNTS_R$r";
	if ($r >= 22) {
		/* FIXME: These registers cannot be changed for now, because because of the severe damage they would do.
		 * Maybe these issuses can be sorted out one day.
		 */
		$kconfig_r = "config ${default}_R$r\n\tdef_bool y\n\n";
	}
	$kconfig .= $kconfig_r;
}

$counter_used = $counter_used_defs."#define NR_USED_REGS ($counter_used)\n";
$counter_saved = $counter_saved_defs."#define NR_SAVED_REGS ($counter_saved)\n";
$kconfig .= "endmenu\n";

file_put_contents("Kconfig.register-layout", $kconfig);
file_put_contents("Makefile.register-layout", $makefile);
file_put_contents("kernel/used-regs-counter.h", $counter_used);
file_put_contents("kernel/saved-regs-counter.h", $counter_saved);
