/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_MATH_H
#define _ASM_MATH_H

/* This file is for multi-purpose arithmetics. */
#include <linux/types.h>

static inline u16 mul_u16_div_256_c(u16 a, const u16 b) {
	u16 ret;
	ret  = ((a & 0xff) * (b & 0xff)) >> 8;
	ret += (a >> 8) * (b & 0xff);
	ret += (a & 0xff) * (b >> 8);
	ret += ((b >> 8) * (a >> 8)) << 8;
	return ret;
}


#define mul_u16_div_256(a_, b_) ({                           \
	u16 a = a_;                                           \
	const u16 b = b_;                                     \
	u16 ret;                                              \
	asm(   "mul	%B[a], %A[b] ; ret = a[1] * b[0]"     \
	"\n	movw	%[ret],  r0"                          \
	"\n	mul	%A[a], %B[b] ; ret += a[0] * b[1]"    \
	"\n	add	%A[ret], r0"                          \
	"\n	adc	%B[ret], r1"                          \
	"\n	mul	%A[a], %A[b] ; ret += (a[0] * b[0]) >> 8"  \
	"\n	add	%A[ret], r1"                          \
	"\n	clr     r1"                                \
	"\n	adc	%B[ret], r1"                          \
	"\n	mul	%B[a], %B[b] ; ret[1] += (a[1] * b[1])"  \
	"\n	add	%B[ret], r0"                          \
	"\n	clr	r1 ; clobber Wirkungslos! "           \
	: [ret]"=&w"(ret)                                     \
	: [a]"w"(a), [b]"w"(b)                                \
	: "r0", "r1");                                        \
	ret;                                                  \
})
#define U16_MUL_DOUBLE(u16, dbl) ( \
	__builtin_constant_p(u16) ? \
	mul_u16_div_256_c(u16, (int)(256. * dbl)) : \
	mul_u16_div_256(u16, (int)(256. * dbl)) \
)
#define U16_MUL_DOUBLE_c(u16, dbl) mul_u16_div_256_c(u16, (int)(256. * dbl))


#endif /* _ASM_MATH_H */
