#ifndef _AVR_ASM_GPIO_H
#define _AVR_ASM_GPIO_H

#include <linux/kernel.h>
#include <linux/bits.h>

#include <asm/io.h>
#include <asm/gpios.h>

#define GPIO_DDR(gpio)          CONCATENATE(gpio, _DDR)
#define GPIO_PORT(gpio)         CONCATENATE(gpio, _PORT)
#define GPIO_PIN(gpio)          CONCATENATE(gpio, _PIN)
#define GPIO_BITNUM(gpio)       CONCATENATE(gpio, _BITNUM)
#define GPIO_BIT(gpio)          BIT(GPIO_BITNUM(gpio))
#define GPIO_NBITS(gpio)        CONCATENATE(gpio, _NBITS)
#define GPIO_BITS(gpio, nbits)  (((1 << (nbits)) - 1) << GPIO_BITNUM(gpio))
#define GPIO_FULL(gpio, nbits)  (GPIO_BITNUM(gpio) == 0 && GPIO_NBITS(gpio) == (nbits))

#define gpio_set_output(gpio)    out(GPIO_DDR(gpio),  in(GPIO_DDR(gpio))  |  GPIO_BIT(gpio))
#define gpio_set_input(gpio)     out(GPIO_DDR(gpio),  in(GPIO_DDR(gpio))  & ~GPIO_BIT(gpio))
#define gpio_out1(gpio)          out(GPIO_PORT(gpio), in(GPIO_PORT(gpio)) |  GPIO_BIT(gpio))
#define gpio_out0(gpio)          out(GPIO_PORT(gpio), in(GPIO_PORT(gpio)) & ~GPIO_BIT(gpio))
#if defined(CONFIG_ATMEGA48A) || defined(CONFIG_ATMEGA48PA) \
 || defined(CONFIG_ATMEGA88A) || defined(CONFIG_ATMEGA88PA) \
 || defined(CONFIG_ATMEGA168A) || defined(CONFIG_ATMEGA168PA) \
 || defined(CONFIG_ATMEGA328) || defined(CONFIG_ATMEGA328P) \
// FIXME: We don't know if that works for all AVRs
#define gpio_toggle(gpio)        out(GPIO_PIN(gpio),  in(GPIO_PIN(gpio))  |  GPIO_BIT(gpio))
#else
#define gpio_toggle(gpio)        out(GPIO_PORT(gpio), in(GPIO_PORT(gpio)) ^  GPIO_BIT(gpio))
#endif
#define gpio_out(gpio, v)        out(GPIO_PORT(gpio), (v) ? (in(GPIO_PORT(gpio)) | GPIO_BIT(gpio)) : (in(GPIO_PORT(gpio)) & ~GPIO_BIT(gpio)))
#define gpio_in(gpio)            in(GPIO_PIN(gpio) & GPIO_BIT(gpio))

#define gpiogroup_set_output_v(gpio, nbits, values) \
out(GPIO_DDR(gpio), (GPIO_FULL(gpio, nbits) ? 0 : (in(GPIO_DDR(gpio)) & ~GPIO_BITS(gpio, nbits))) \
 | values << GPIO_BITNUM(gpio))

#define gpiogroup_set_output(gpio, nbits)    out(GPIO_DDR(gpio),  in(GPIO_DDR(gpio)) |  GPIO_BITS(gpio, nbits))
#define gpiogroup_set_input(gpio, nbits)     out(GPIO_DDR(gpio),  in(GPIO_DDR(gpio)) & ~GPIO_BITS(gpio, nbits))
#define gpiogroup_out(gpio, nbits, values)   out(GPIO_PORT(gpio), (GPIO_FULL(gpio, nbits) ? 0 : (in(GPIO_PORT(gpio)) & ~GPIO_BITS(gpio, nbits))) | values << GPIO_BITNUM(gpio))
#define gpiogroup_in(gpio, nbits)            in(GPIO_PIN(gpio) >> GPIO_BITNUM(gpio))

#endif /* _AVR_ASM_GPIO_H */
