// SPDX-License-Identifier: GPL-2.0
#ifndef _ASM_AVR_DELAY_H
#define _ASM_AVR_DELAY_H

extern void __builtin_avr_delay_cycles(unsigned long);

#define udelay(us) __builtin_avr_delay_cycles((unsigned long)((us) * 0.000001 * CONFIG_CPUFREQ))
#define mdelay(ms) __builtin_avr_delay_cycles((unsigned long)((ms) * 0.001 * CONFIG_CPUFREQ))

#endif /* _ASM_AVR_DELAY_H */
