// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2017-2019 Rupert Eibauer. All rights reserved.

#include <linux/init.h>
#include <linux/sched.h>

#include <asm/io.h>
#include <asm/system.h>


//#define NO_WAIT
#ifdef NO_WAIT

#define wait() do { } while(0)

#else /* NO_WAIT */
static void wait(void) {
	volatile int wait_counter;
	volatile int wait_counter2;
	for (wait_counter = 0; wait_counter < 50; wait_counter++)
	for (wait_counter2 = 0; wait_counter2 < 1000; wait_counter2++);
}
#endif /* NO_WAIT */

struct task_struct o1;
void fo1(void *arg) {
	for (;;) {
		wait();
		out(PORTB, in(PORTB) ^ 1);
	}
}
struct task_struct o2;
void fo2(void *arg) {
	for (;;) {
		wait();
		out(PORTB, in(PORTB) ^ 2);
	}
}

static int init_sched_other_test(void) {
	int i;
	out(DDRB, 0x3f);
	out(DDRC, 0x3f);
	wait();
	wait();
	wait();
	wait();
	out(PORTB, 7);
	for (i = 0; i <= 7; i++) {
		wait();
		out(PORTB, i);
	}
	wait();
	out(PORTB, 0);

	kernel_thread(&o1, fo1, NULL, -1);
	kernel_thread(&o2, fo2, NULL, -2);

	out(PORTB, 1);
	return 0;
}

initcall(init_sched_other_test);
