/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_TIMER_H
#define _LINUX_TIMER_H

#include <linux/types.h>
#include <linux/jiffies.h>
#include <asm/timer.h>

/* For the moment, we use a simple list-based timer structure.
   For larger systems, a tree-based system may be required.
 */
struct timer {
	struct timer *next;
#ifdef CONFIG_DEL_TIMER
	struct timer *prev;
#endif
	jiffies_t expires;
	void (*function)(void);
};

void add_timer(struct timer *timer);
void _add_timer(struct timer *timer); /* called with interrupts disabled */
#ifdef CONFIG_DEL_TIMER
/* For the moment, only add_timer is supported. */
void _del_timer(struct timer *timer);
void del_timer(struct timer *timer);
void _mod_timer(struct timer *timer, jiffies_t expires);
void mod_timer(struct timer *timer, jiffies_t expires);
#endif

extern struct timer *next_timer;

/* These functions are for arch-code only. */
static inline void _del_first_timer(void) {
	struct timer *n = next_timer;

	next_timer = n->next;
#ifdef CONFIG_DEL_TIMER
	n->next = NULL;
	n->prev = NULL;
	if (next_timer)
		next_timer->prev = NULL;
#endif
}

#define initial_timer(t)					\
	static const struct timer* __timer_##t[]			\
	__attribute__((section("__initial_timers"), unused))		\
	= &t;

#endif /* _LINUX_TIMER_H */
