/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_PRINTK_H
#define _LINUX_PRINTK_H

#include <linux/kern_levels.h>

#include <asm/flash.h>

#ifdef CONFIG_PRINTK

extern void printk_(const char *fmt, ...) __attribute__ ((format (printf, 1, 2)));

#define printk__(lvl, fmt, ...)  do { if (lvl <= KERN_LOGLEVEL) printk_(FMTSTR(fmt), ##__VA_ARGS__); } while(0)
#define printk(fmt, ...) printk__(fmt, ##__VA_ARGS__)

#else /* CONFIG_PRINTK */

#define printk(fmt, ...) do { } while(0)

#endif /* CONFIG_PRINTK */

#endif /* _LINUX_PRINTK_H */