/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_JIFFIES_H
#define _LINUX_JIFFIES_H

#include <linux/types.h>
 
#ifdef CONFIG_JIFFIES_32BIT
typedef u32 jiffies_t;
typedef s32 signed_jiffies_t;
#elif defined(CONFIG_JIFFIES_24BIT)
typedef u24 jiffies_t;
typedef s24 signed_jiffies_t;
#elif defined(CONFIG_JIFFIES_16BIT)
typedef u16 jiffies_t;
typedef s16 signed_jiffies_t;
#else
#error
#endif

/* FIXME: The below contents are directly copied (with minor 
   modifications) from linux kernel source code. Beware if we need 
   to change the license. */

/*
 *      These inlines deal with timer wrapping correctly. You are
 *      strongly encouraged to use them
 *      1. Because people otherwise forget
 *      2. Because if the timer wrap changes in future you won't have to
 *         alter your driver code.
 *
 * time_after(a,b) returns true if the time a is after time b.
 *
 * Do this with "<0" and ">=0" to only test the sign of the result. A
 * good compiler would generate better code (and a really good compiler
 * wouldn't care). Gcc is currently neither.
 */
#define time_after(a,b)         \
         ((signed_jiffies_t)(a) - (signed_jiffies_t)(b) > 0)
#define time_before(a,b)        time_after(b,a)

#define time_after_eq(a,b)      \
         ((signed_jiffies_t)(a) - (signed_jiffies_t)(b) >= 0)
#define time_before_eq(a,b)     time_after_eq(b,a)

#endif /* _LINUX_JIFFIES_H */
