/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_COMPILER_H
#define _LINUX_COMPILER_H

#ifdef __GNUC__

#define __noreturn                      __attribute__((noreturn))

/* Mark functions as cold. gcc will assume any path leading to a call
   to them will be unlikely.  This means a lot of manual unlikely()s
   are unnecessary now for any paths leading to the usual suspects
   like BUG(), printk(), panic() etc. [but let's keep them for now for
   older compilers]

   Early snapshots of gcc 4.3 don't support this and we can't detect this
   in the preprocessor, but we can live with this because they're unreleased.
   Maketime probing would be overkill here.

   gcc also has a __attribute__((__hot__)) to move hot functions into
   a special section, but I don't see any sense in this right now in
   the kernel context */
#define __cold                  __attribute__((__cold__))

#define __linktime_error(message) __attribute__((__error__(message)))

#define __maybe_unused __attribute__((unused))

#endif /* __GNUC__ */


#ifndef __cold
#define __cold
#endif

#ifndef __noreturn
#define __noreturn
#endif

#endif /* _LINUX_COMPILER_H */
