// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2010, 2014, 2018-2019 Rupert Eibauer. All rights reserved.

#ifdef __RBTMPL_H__

#undef RB_SIZE
#undef RB_MASK
#undef rb_pos_t
#undef RB_T
#undef RB_INC
#undef RB_PUT_CHAR
#undef RB_PUT_CHAR_NOCHECK
#undef RB_GET_CHAR
#undef RB_GET_CHAR_NOTEMPTY
#undef RB_EMPTY
#undef RB_FULL

#else /* __RBTMPL_H__ */

#include <linux/types.h>

#define __RBTMPL_H__

#endif /* __RBTMPL_H__ */

#ifndef RB_SHIFT
#error You need to define RB_SHIFT
#endif

#define RB_SIZE (1<<RB_SHIFT)
#define RB_MASK ((1<<RB_SHIFT)-1)

/* The following belongs into rb_tmpl.h */
#if RB_SIZE > 256
#define rb_pos_t u16
#else
#define rb_pos_t u8
#endif
#define RB_T \
struct { \
	rb_pos_t start; \
	rb_pos_t end; \
	char bytes[RB_SIZE]; \
}
#define RB_INC(x) ((x + 1) & RB_MASK)

#define RB_PUT_CHAR_NOCHECK(rb, ch) do { \
	rb_pos_t next_end = RB_INC((rb).end); \
	(rb).bytes[(rb).end] = ch; \
	(rb).end = next_end; \
} while(0)

#define RB_PUT_CHAR(rb, ch) ({ \
	char retval; \
	rb_pos_t next_end = RB_INC((rb).end); \
	if (next_end != (rb).start) { \
		RB_PUT_CHAR_NOCHECK(rb, ch); \
		retval = 0; \
	} else { \
		retval = -1; \
	} \
	retval; \
})

#define RB_GET_CHAR_NOCHECK(rb) ({ \
	u8 retval; \
	retval = (rb).bytes[(rb).start]; \
	(rb).start = RB_INC((rb).start); \
	retval; \
})

#define RB_GET_CHAR(rb) ({ \
	s16 retval = -1; \
	if ((rb).start != (rb).end) { \
		retval = RB_GET_CHAR_NOCHECK(rb); \
	} \
	retval; \
})

#define RB_EMPTY(rb) ((rb).start == (rb).end)
#define RB_FULL(rb) ((rb).start == RB_INC((rb).end))

