#!/bin/sh

if [ "$CONFIG_IRQ" = "y" ]; then
	echo "  GEN     arch/avr/include/generated/vectable.h"
	NR_IRQS=$(grep "#define NR_IRQS" arch/${SRCARCH}/devs/${CPU}/include/asm/irqvec.h  | sed 's/\#define NR_IRQS //')
	FLASH_END=$(grep "#define FLASH_END" arch/${SRCARCH}/devs/${CPU}/include/asm/limits.h  | sed 's/\#define FLASH_END//')
	
	if [ $[FLASH_END] -lt 8192 ]; then
		JMP=rjmp
		CALL=rcall
	else
		JMP=jmp
		CALL=call
	fi
	hard_vectors=$(nm rupsched-1.o | grep " T __vector_" | sed 's/[0-9a-f]\{8\} T __vector_//')
	hard_vectors=" $(echo $hard_vectors) "
	
	VECTABLE=arch/avr/include/generated/vectable.h
	if [ "$CONFIG_IRQ_COMMON" = "y" ]; then
		VECTOR_DEFAULT="$CALL __irqentry"
	elif [ "$CONFIG_PANIC" = "y" ]; then
		VECTOR_DEFAULT="$CALL _panic"
	else
		VECTOR_DEFAULT="$JMP __init"
	fi
	echo "/* DO NOT EDIT. This file is created by arch/avr/scripts/prelink-script.h */" >$VECTABLE
	echo -e "\t$JMP __init" >>$VECTABLE
	for irq in $(seq 1 $NR_IRQS); do
		if [[ "$hard_vectors" == *" $irq "* ]]; then
			echo -e "\t$JMP __vector_$irq"  >>$VECTABLE
		else
			echo -e "\t$VECTOR_DEFAULT"  >>$VECTABLE
		fi
	done
	make arch/avr/kernel/head.o
	LATE_OBJS="$LATE_OBJS arch/avr/kernel/head.o"
fi
