// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2018-2019 Rupert Eibauer. All rights reserved.

#include <linux/sched.h>
#include <linux/printk.h>

#include <asm/io.h>


#ifdef CONFIG_KTHREAD_ARG
/* Jumping a task is easy.*/
__attribute__((naked))
static void kick_task(void) {
	asm volatile (
		"pop r25\n\t"
		"pop r24\n\t"
		"reti\n\t"
	);
}
#endif


#ifdef CONFIG_END_TASK

#ifdef CONFIG_KTHREAD_ARG
#define STACK_PRELOAD 8
#else
#define STACK_PRELOAD 4
#endif
#define END_TASK_OFFSET 2


#else /* CONFIG_END_TASK */

#ifdef CONFIG_KTHREAD_ARG
#define STACK_PRELOAD 6
#else
#define STACK_PRELOAD 2
#endif
#define END_TASK_OFFSET 0

#endif /* CONFIG_END_TASK */

#define STACK_REG_PAYLOAD 18
#define CLEAR_STACK

void setup_task(struct task_struct *task, void (*f)(void *arg), void *arg) {
#ifdef CLEAR_STACK
	int a;

#ifdef CONFIG_STACK_SIZE_REPORTING
	for (a = 0; a < CONFIG_STACK_SIZE - STACK_PRELOAD; a++)
		task->stack[a] = 0xaa;
#endif
	/* The task gets its registers initialized to 0 (Unneeded crap or useful?) poisoning may be better for debugging. */
	for (a = CONFIG_STACK_SIZE - STACK_PRELOAD - STACK_REG_PAYLOAD; a < CONFIG_STACK_SIZE - STACK_PRELOAD; a++)
		task->stack[a] = 0;
#if CONFIG_STACK_GUARD > 0
	for (a = 0; a < CONFIG_STACK_GUARD; a++) {
		task->stack_guard1[a] = '1';
		task->stack_guard2[a] = '2';
	}
#endif
#endif /* CLEAR_STACK */

#ifdef CONFIG_LARGE_SP
	task->state.L_SP = &task->stack[CONFIG_STACK_SIZE - STACK_PRELOAD - 1 - STACK_REG_PAYLOAD];
	printk(KERN_DEBUG "new task=%x SP=%x kick=%x\n", task, task->state.L_SP, &task->stack[CONFIG_STACK_SIZE - 6 - END_TASK_OFFSET]);
#else
	task->state.sp = CONFIG_STACK_SIZE - STACK_PRELOAD - 1 - STACK_REG_PAYLOAD;
	printk(KERN_DEBUG "new task=%x sp=%x kick=%x\n", task, task->state.sp, &task->stack[CONFIG_STACK_SIZE - 6 - END_TASK_OFFSET]);
#endif

	/* The amount of space used here must equal STACK_PRELOAD */
#ifdef CONFIG_KTHREAD_ARG
	task->stack[CONFIG_STACK_SIZE - 6 - END_TASK_OFFSET] = ((unsigned int)kick_task)>>8;
	task->stack[CONFIG_STACK_SIZE - 5 - END_TASK_OFFSET] = ((unsigned int)kick_task)&0xff;
	task->stack[CONFIG_STACK_SIZE - 4 - END_TASK_OFFSET] = ((unsigned int)arg)>>8;
	task->stack[CONFIG_STACK_SIZE - 3 - END_TASK_OFFSET] = ((unsigned int)arg)&0xff;
#endif	
	task->stack[CONFIG_STACK_SIZE - 2 - END_TASK_OFFSET] = ((unsigned int)f)>>8;
	task->stack[CONFIG_STACK_SIZE - 1 - END_TASK_OFFSET] = ((unsigned int)f)&0xff;
/* We simply let it return to schedule.
 * Remember, calling schedule without _taskEnqueue(), the scheduler will simply
 * forget about current as soon as it finds another task to run.
 */

#ifdef CONFIG_END_TASK
	task->stack[CONFIG_STACK_SIZE - 2] = ((unsigned int)schedule)>>8;
	task->stack[CONFIG_STACK_SIZE - 1] = ((unsigned int)schedule)&0xff;
#endif
}
