/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_AVR_INTERRUPT_H
#define _ASM_AVR_INTERRUPT_H

#include <linux/types.h>
#include <asm/irqvec.h>

#ifdef CONFIG_IRQ

#define REQUEST_DIRECT_IRQ_(vec, func) \
static void func(u8); \
__attribute__((signal)) void __vector_##vec(void) { \
	func(vec); \
	resched_after_irq(); \
}
#define REQUEST_DIRECT_IRQ(vec, func) REQUEST_DIRECT_IRQ_(vec, func)

#define REQUEST_DIRECT_IRQ_NO_RESCHED_(vec, func) \
static void func(u8); \
__attribute__((signal)) void __vector_##vec(void) { \
	func(vec); \
}
#define REQUEST_DIRECT_IRQ_NO_RESCHED(vec, func) REQUEST_DIRECT_IRQ_NO_RESCHED_(vec, func)

#define REQUEST_NAKED_IRQ_(vec, func) \
__attribute__((naked)) static void func(void); \
__attribute__((naked, alias(#func), used)) static void __vector_##vec(void);

#define REQUEST_NAKED_IRQ(vec, func) REQUEST_NAKED_IRQ_(vec, func)

#endif

#ifdef CONFIG_IRQ_CLASSIC

#define REQUEST_IRQ_(vec, func) \
static void func(u8); \
__attribute__((signal)) void __vector_##vec(void) { \
	func(vec); \
	resched_after_irq(); \
}
#define REQUEST_IRQ(vec, func) REQUEST_IRQ_(vec, func)

#define REQUEST_IRQ_NO_RESCHED_(vec, func) \
static void func(u8); \
__attribute__((signal)) void __vector_##vec(void) { \
	func(vec); \
}
#define REQUEST_IRQ_NO_RESCHED(vec, func) REQUEST_IRQ_NO_RESCHED_(vec, func)

#elif defined CONFIG_IRQ_COMMON_STATIC

#define REQUEST_IRQ_(vec, func) \
static void func(u8); \
void _vector_##vec(u8 v) { \
	func(v); \
}
#define REQUEST_IRQ(vec, func) REQUEST_IRQ_(vec, func)
#define REQUEST_IRQ_NO_RESCHED(vec, func) REQUEST_IRQ_(vec, func)

#elif defined CONFIG_IRQ_COMMON_DYNAMIC

#include <linux/init.h>

void request_irq(u8 vector, void (*func)(u8 vector));

#define REQUEST_IRQ_(vec, func) \
static void func(u8); \
static int request_vector_##vec(void) { \
	request_irq(vec, func); \
	return 0; \
} \
initcall(request_vector_##vec)

#define REQUEST_IRQ(vec, func) REQUEST_IRQ_(vec, func)
#define REQUEST_IRQ_NO_RESCHED(vec, func) REQUEST_IRQ_(vec, func)

#endif

#endif /* _ASM_AVR_INTERRUPT_H */
