// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2010, 2017-2019 Rupert Eibauer. All rights reserved.

#include <linux/types.h>
#include <linux/timer.h>
#include <linux/printk.h>
#include <linux/init.h>

#include <asm/system.h>
#include <asm/io.h>


//#define NO_WAIT
#ifdef NO_WAIT

#define wait() do { } while(0)

#else /* NO_WAIT */
static void wait(void) {
	volatile int wait_counter;
	volatile int wait_counter2;
	for (wait_counter = 0; wait_counter < 50; wait_counter++)
	for (wait_counter2 = 0; wait_counter2 < 1000; wait_counter2++);
}
#endif /* NO_WAIT */


#define TEST_HZ 8

static struct timer test_timer0, test_timer1, test_timer2;

static void timer_callback0(void) {
	out(PORTC, in(PORTC) ^ 1);
#ifdef CONFIG_DEL_TIMER
	mod_timer(&test_timer0, test_timer0.expires + HZ / TEST_HZ);
#else
	test_timer0.expires += HZ / TEST_HZ;
	add_timer(&test_timer0);
#endif
}
static struct timer test_timer0 = {
	.function = timer_callback0,
	.expires  = HZ * 2,
};

static void timer_callback1(void) {
	out(PORTC, in(PORTC) ^ 2);
#ifdef CONFIG_DEL_TIMER
	mod_timer(&test_timer1, test_timer1.expires + HZ / 4 / TEST_HZ);
#else
	test_timer1.expires += HZ / 4 / TEST_HZ;
	add_timer(&test_timer1);
#endif
}
static struct timer test_timer1 = {
	.function = timer_callback1,
	.expires  = HZ + HZ / 4 / TEST_HZ,
};

static void timer_callback2(void) {
	out(PORTC, in(PORTC) ^ 4);
#ifdef CONFIG_DEL_TIMER
//	mod_timer(&test_timer2, test_timer2.expires + HZ / 16 / TEST_HZ);
	mod_timer(&test_timer2, test_timer2.expires + HZ / 881);
#else
	test_timer2.expires += HZ / 881;
	add_timer(&test_timer2);
#endif
}
static struct timer test_timer2 = {
	.function = timer_callback2,
	.expires  = HZ + 1 + HZ / 881,
};

static struct timer accel_timer;
static void accel_callback(void) {
	static u32 delay = HZ / 10000;
	static u32 scount;

	out(PORTC, in(PORTC) ^ 4);
	scount += delay;
	
	if (scount >= HZ && delay != 0) {
		scount = 0;
		delay--;
	}
	accel_timer.expires += delay;
	_add_timer(&accel_timer);
}
static struct timer accel_timer = {
	.function = accel_callback,
	.expires  = HZ,
};

static int init_timer_test(void) {
	int i;
	printk(KERN_NOTICE "Test starting\n");
	out(DDRB, 0x7);
	out(DDRC, 0x3f);
	out(DDRD, 0);
	out(PORTC, 7);
	wait();
	wait();
	wait();
	wait();
	for (i = 0; i <= 7; i++) {
		wait();
		out(PORTC, i);
	}
	wait();
	out(PORTC, 0);

	local_irq_enable();
	add_timer(&accel_timer);
//	add_timer(&test_timer2);
	add_timer(&test_timer1);
	add_timer(&test_timer0);
	printk(KERN_NOTICE "Test init done\n");

// 	for(;;) {
//	  PORTC = (jiffies >> 360) & 3;
// 	  wait();
// 	}
	return 0;
}

initcall(init_timer_test);
