#!/bin/sh
# SPDX-License-Identifier: GPL-2.0
#
# link rupsched

if [ "$1" = "clean" ]; then
	rm -f progmem.bin fmtstr.map lib/printf_config.h
	exit 0
fi

# echo "link-rupsched.sh called!"
# echo KBUILD_VMLINUX_INIT=$KBUILD_VMLINUX_INIT
# echo KBUILD_VMLINUX_MAIN=$KBUILD_VMLINUX_MAIN
# echo KBUILD_VMLINUX_LIBS=$KBUILD_VMLINUX_LIBS
# echo kallsymso=$kallsymso
# echo objects=$objects
# echo KBUILD_LDFLAGS=$KBUILD_LDFLAGS
# echo LDFLAGS_rupsched=$LDFLAGS_rupsched
# echo LD=$LD
# echo CC=$CC
KBUILD_c_flags="${KBUILD_CPPFLAGS} ${KBUILD_CFLAGS} ${LINUXINCLUDE}"


V=0
if [ "$quiet" = "" ]; then
	V=1
fi

exit_if_fail() {
	local v=$?
	
	if [ "$1" != "" ]; then
		v=$1
	fi
	if [ $v = 0 ]; then
		return
	fi
	echo "link-rupsched.sh failed" >&2
	exit 1
}

build_command() {
	msg="$1"
	shift
	if [ $V = 1 ]; then
		echo "$@"
	else
		echo "$msg"
	fi
	$@
	exit_if_fail
}
build_ld() {
	target="$1"
	shift
	msg="  LD      $target"
	if [ $V = 1 ]; then
		echo "${CC} -o $target $@"
	else
		echo "$msg"
	fi
	${CC} -o $target $@ >.$target.warning 2>&1
	status=$?
	cat .$target.warning | grep -v "warning: -z relro ignored" >&2
	rm .$target.warning
	exit_if_fail $status
}
build_cc() {
	target="$1"
	shift
	msg="  CC      $target"
	source=${target:0:-2}.c
	if [ $V = 1 ]; then
		echo "${CC} ${KBUILD_c_flags} -c -o $target $source"
	else
		echo "$msg"
	fi
	${CC} ${KBUILD_c_flags} -c -o $target $source
	exit_if_fail
}
build_ar() {
	target="$1"
	shift
	msg="  AR      $target"
	if [ $V = 1 ]; then
		echo "${AR} rcSTP${KBUILD_ARFLAGS} $target $@"
	else
		echo "$msg"
	fi
	rm -f $target
	${AR} rcSTP${KBUILD_ARFLAGS} $target $@
	exit_if_fail
	if [ $V = 1 ]; then
		echo "${ARCH}-ranlib $target"
	fi
	${ARCH}-ranlib $target
	exit_if_fail
}

build_ar_add() {
	target="$1"
	shift
	msg="  AR      $target"
	if [ $V = 1 ]; then
		echo "${AR} rcSTP${KBUILD_ARFLAGS} $target $@"
	else
		echo "$msg"
	fi
	${AR} rcSTP${KBUILD_ARFLAGS} $target $@
	exit_if_fail
	if [ $V = 1 ]; then
		echo "${ARCH}-ranlib $target"
	fi
	${ARCH}-ranlib $target
	exit_if_fail
}

# find out the linker arch

objects="-Wl,--whole-archive $KBUILD_VMLINUX_INIT $KBUILD_VMLINUX_MAIN -Wl,--no-whole-archive $KBUILD_VMLINUX_LIBS"

for fname in $KBUILD_VMLINUX_LATEOBJS; do
	if [ $fname = "lib/vdevprintf.o" ]; then
		build_ld rupsched-1.o ${KBUILD_LDFLAGS} ${LDFLAGS_rupsched} -r ${objects}
		build_command "  OBJCOPY progmem.bin" ${OBJCOPY} -j .progmem.data -O binary rupsched-1.o progmem.bin
		build_command "  GEN     fmtstr.map" nm rupsched-1.o | grep "r __fmtstr" >fmtstr.map
		build_command "  GEN     lib/printf_config.h" php lib/gen_printf_config.php fmtstr.map progmem.bin lib/printf_config.h
		build_cc lib/vdevprintf.o
		# FIXME: Add vdevprintf to lib/lib.a
		build_ar_add lib/lib.a lib/vdevprintf.o
		# collect .progmem.data objects
		# and merge identical (sub-)strings.
		# This should also save some bytes
	fi
	if [ $fname = "arch/avr/kernel/head.o" ]; then
	# Look for REQUEST_IRQ_NAKED and put them directly in the vector table,
	# no matter if we have CONFIG_IRQ_COMMON or not.
	# This bypasses a limitation of the weak symbol logic, which cannot choose
	# between jmp and call based on the presence of a weak symbol.
	:
	fi
done

build_ld rupsched.o ${KBUILD_LDFLAGS} ${LDFLAGS_rupsched} ${objects}
