// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2017-2019 Rupert Eibauer. All rights reserved.

#ifdef TEST

#include <stdint.h>
#define s16 int16_t
#define u8 uint8_t
#include <stdio.h>
#define __flashdata_decl
#define flash_read(x) (x)

#else

#include <linux/types.h>
#include <asm/flash.h>

#endif

#define QUADRANT_SIZE 180

static u16 __flashdata_decl SINUS_QUADRANT1[QUADRANT_SIZE+1] = {
#include "sin_11.h"
};

s16 sin_11(u16 deg) {
	s16 retval;

#if 0
	if (deg > QUADRANT_SIZE * 4)
		deg -= QUADRANT_SIZE * 4;
	if (deg <= QUADRANT_SIZE) {
#endif
		retval = flash_read(SINUS_QUADRANT1[(u8)deg]);
#if 0
	} else if (deg <= QUADRANT_SIZE*2) {
		retval = flash_read(SINUS_QUADRANT1[(u8)(QUADRANT_SIZE*2 - deg)]);
	} else if (deg <= QUADRANT_SIZE*3) {
		retval = -flash_read(SINUS_QUADRANT1[(u8)(deg - QUADRANT_SIZE*2)]);
	} else {
		retval = -flash_read(SINUS_QUADRANT1[(u8)(QUADRANT_SIZE*4 - deg)]);
	}
#endif
	return retval;
}

#ifdef TEST
int main(void) {
	int i;
	for (i = 0; i <= QUADRANT_SIZE * 4; i++) {
		printf("sin_11(%d) = %d\n", i, sin_11(i));
	}
	return 0;
}
#endif
