<?php
// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2018-2019 Rupert Eibauer. All rights reserved.

include("PrintfConf.inc.php");

if (count($argv) != 4) {
	echo "Wrong number of arguments!\n";
	exit(1);
}

$map = file_get_contents($argv[1]);
$progmem = file_get_contents($argv[2]);

$conf = new PrintfConf();

$map = explode("\n", $map);

foreach ($map AS $symbol) {
	$symbol = explode(" ", $symbol);
	if (count($symbol) != 3)
		break;
	$addr = hexdec($symbol[0]);
	$name = $symbol[2];
	$nulpos = strpos($progmem, chr(0), $addr);
	if ($nulpos === false) {
		printf("Error: Symbol $name has no NUL at end!\n");
		exit(1);
	}
	$data = substr($progmem, $addr, $nulpos - $addr);
// 	printf("FormatString=<<<%s>>>\n", $data);
	$conf->parseFmtStr($data);
}

file_put_contents($argv[3], $conf->dumpConfig());
exit(0);