<?php
// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2018-2019 Rupert Eibauer. All rights reserved.

class PrintfConf {
	private $features = array();
	function __construct() {}
	function parseFmtStr($fmt) {
		$pos = 0;

		for (;;) {
			if ($pos == strlen($fmt))
				break;
			$ch = $fmt[$pos++];
			if ($ch !== '%') {
				continue;
			}
			$width = 0;
			$sign = 0;
			$pad = " ";
			$flags = 0;
			$long = "";
			$lpad = 0;
nextfmt:
			if ($pos == strlen($fmt))
				break;
			$ch = $fmt[$pos++];
// 			echo "FMTCH: $ch\n";
			if (ord($ch) >= ord('0') && ord($ch) <= ord('9')) {
				if ($ch != '0' || $width) {
					$width = 1;
				} else {
					$pad = $ch;
				}
				goto nextfmt;
			}
			switch($ch) {
				case '%': 
					$this->features['CONFIG_PRINTF_PERCENT'] = true;
					break;
				case 'l': $long = "l";   goto nextfmt;
				case '-': $lpad = 1;     goto nextfmt;
				case ' ':
				case '+': $sign = $ch;   goto nextfmt;

				case 'c':
					$this->features["CONFIG_PRINTF_c"] = true;
					break;
				case 's':
					if ($width)
						$this->features["CONFIG_PRINTF_STRPAD"] = true;
					$this->features["CONFIG_PRINTF_s"] = true;
					break;
				case 'S':
					if ($width)
						$this->features["CONFIG_PRINTF_STRPAD"] = true;
					if ($lpad)
						$this->features["CONFIG_PRINTF_STR_LPAD"] = true;
					$this->features["CONFIG_PRINTF_S"] = true;
					break;
				case 'd':
				case 'u':
				case 'x':
// 				case 'X':
				case 'o':
					if ($width) {
						$this->features["CONFIG_PRINTF_NUMPAD"] = true;
						if ($pad == ' ')
							$this->features["CONFIG_PRINTF_SPCPAD"] = true;
						else
							$this->features["CONFIG_PRINTF_ZPAD"] = true;
						if ($lpad)
							$this->features["CONFIG_PRINTF_NUM_LPAD"] = true;
					}
					if ($sign !== 0) {
						if ($sign == ' ')
							$this->features["CONFIG_PRINTF_SPC"] = true;
						else if ($sign == '+')
							$this->features["CONFIG_PRINTF_PLUS"] = true;
					}
					$this->features["CONFIG_PRINTF_".$long.$ch] = true;
					$this->features["CONFIG_PRINTF_".$long.$ch] = true;
					break;
				default:
					echo "ERROR: Printf Format %$ch is not supported.\n";
					exit(1);
			}
		}
	}
	function dumpConfig() {
		$ret  = "/* DO NOT EDIT. This file was generated by ".basename(__FILE__)." */\n";
		$ret .= "#ifndef __PRINTF_CONFIG_H__\n";
		$ret .= "#define __PRINTF_CONFIG_H__\n";
		ksort($this->features);
		if (count($this->features) == 0)
			$ret .= "#define CONFIG_PRINTF_NONE\n";
		foreach ($this->features AS $name => $true) {
			$ret .= "#define $name\n";
		}
		$ret .= "#endif /* __PRINTF_CONFIG_H__ */\n";
		return $ret;
	}
}
