// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2014, 2018-2019 Rupert Eibauer. All rights reserved.

#include <linux/types.h>
#include <linux/timer.h>
#include <linux/printk.h>

#include <asm/system.h>

struct timer *next_timer = NULL;
#define timer_list next_timer


/* list private */
static void __add_timer(struct timer *timer) {
	struct timer *t;
	struct timer *next;
#if 1
	if (time_before_eq(timer->expires, jiffies)) {
		 /* If already expired, we schedule it for the next timeslice.
		    We cannot call it now, because timers which are updated by
		    their handler would eat up our stack within a jiffy
		  */
		timer->expires = jiffies + 1;
	}
#endif
	if (timer_list == NULL || time_after(timer_list->expires, timer->expires)) {
#ifdef CONFIG_DEL_TIMER
		if (timer_list) {
			timer_list->prev = timer;
		}
		timer->prev = NULL;
#endif
		timer->next = timer_list;
		timer_list = timer;
		_update_timer();
		return;
	}
	for (t = timer_list; t; t = next) {
		next = t->next;
		if (!next || time_after(next->expires, timer->expires)) {
#ifdef CONFIG_DEL_TIMER
			timer->prev = t;
#endif
			timer->next = next;
			t->next = timer;
#ifdef CONFIG_DEL_TIMER
			if (next)
				next->prev = timer;
#endif
			return;
		}
	}
}

#if 0
void print_timer_list(void) {
	struct timer *t;
	jiffies_t j = jiffies;
	t = timer_list;
	printk(KERN_NOTICE, "%p(%d)", t, (s16)(t->expires - j));
	for (t = t->next; t; t = t->next) {
		printk(KERN_NOTICE, " -> %p(%d)", t, (s16)(t->expires - j));
	}
}
#endif

void _add_timer(struct timer *timer) {
	__add_timer(timer);
	if (next_timer == timer)
		_update_timer();
}

/* generic public */
void add_timer(struct timer *timer) {
	irqflags_t flags;

	local_irq_save(flags);
	_add_timer(timer);
	local_irq_restore(flags);
}

/* list private */
#ifdef CONFIG_DEL_TIMER
void _del_timer(struct timer *timer) {
	struct timer *prev = timer->prev;
	struct timer *next = timer->next;

	if (next) {
		next->prev = prev;
		timer->next = NULL;
	}
	if (prev) {
		prev->next = next;
		timer->prev = NULL;
	} else if (timer_list == timer) {
	/* FIXME: There must be a bug somewhere with a timer->prev pointer which should not be NULL but it is! 
	          If the bug is found, the else if above can be converted to else. */
		timer_list = next;
	}
}

/* generic public */
void del_timer(struct timer *timer) {
	char is_old;
	irqflags_t flags;

	local_irq_save(flags);
	is_old = (next_timer == timer);
	_del_timer(timer);
	if (is_old)
		_update_timer();
	local_irq_restore(flags);
}


/* generic public */
void _mod_timer(struct timer *timer, jiffies_t expires) {
	char is_old;

	is_old = (next_timer == timer);
	_del_timer(timer);
	timer->expires = expires;
	__add_timer(timer);
	if (next_timer == timer || is_old)
		_update_timer();
}

void mod_timer(struct timer *timer, jiffies_t expires) {
	irqflags_t flags;

	local_irq_save(flags);
	_mod_timer(timer, expires);
	local_irq_restore(flags);
}
#endif

