/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_INIT_H
#define _LINUX_INIT_H

#define FORCE_STATIC(func) static int func(void)

#define section_func(initfunc, sec, prefix) \
	FORCE_STATIC(initfunc); \
	void prefix##_##initfunc(void) __attribute__((section("." #sec), naked)); \
	void prefix##_##initfunc(void) { initfunc(); }

#define early_initcall(func)  section_func(func, init5, early)
#define module_init(func)     section_func(func, init6, module_init)
#define initcall(func)        section_func(func, init6, initcall)
#define late_initcall(func)   section_func(func, init7, late)

#endif /* _LINUX_INIT_H */
