/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_BUG_H
#define _LINUX_BUG_H

#include <linux/kernel.h>

#ifdef CONFIG_BUG

#define BUG() do { panic("BUG"); } while(0)

#define BUG_ON(condition) do { if (condition) panic("BUG"); } while(0)

#else

#define BUG() do {} while(0)
#define BUG_ON(condition) do {} while(0)

#endif

#endif
