/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (c) 2018-2019 Rupert Eibauer. All rights reserved. */

#include <asm/limits.h>
#include <asm/irqvec.h>

#if FLASH_END > 0x2000
#define _VECTOR_SIZE 4
#else
#define _VECTOR_SIZE 2
#endif

#if _VECTOR_SIZE == 4
#define XJMP jmp
#define XCALL call
#else
#define XJMP rjmp
#define XCALL rcall
#endif

	.file	"head.S"
__SP_H__ = 0x3e
__SP_L__ = 0x3d
__SREG__ = 0x3f
__tmp_reg__ = 0
__zero_reg__ = 1
	.text
#ifdef CONFIG_IRQ_CLASSIC
	.macro	vector name
	.weak	\name
	.set	\name, __bad_interrupt
	XJMP	\name
	.endm
#define VECTOR(x) 	vector __vector_ ## x
#else /* Common IRQ handling */
#define VECTOR(x) 	XCALL __irqentry
#endif

	.section .vectors,"ax",@progbits
	.global	__vectors
	.func	__vectors
__vectors:
	XJMP	__init
#include <asm/vectors.h>
	.endfunc

#ifdef CONFIG_IRQ_CLASSIC
	.text
	.global	__bad_interrupt
	.func	__bad_interrupt
__bad_interrupt:
	.weak	__vector_default
	.set	__vector_default, __init
	XJMP	__vector_default
	.endfunc
	.size	__bad_interrupt, .-__bad_interrupt
#endif

#ifndef CONFIG_IRQ_CLASSIC
/* This is our main interrupt handler.
   It does save all required registers and gets the return address. */
.global	__irqentry
	.type	__irqentry, @function
__irqentry:
	push r1
	push r0
	in r0,__SREG__
	push r0
	clr __zero_reg__
	push r20
	push r21
	push r22
	push r23
	push r24
	push r25
	push r26
	push r27
	push r30
	push r31
	push r28
	push r29
	in r28,__SP_L__
	in r29,__SP_H__
.L__stack_usage = 17
	/* Load the vector address stored by the call in the vector table into r24:r25 */
#if NR_IRQS > 126
	ldd r25,Y+16
#endif
	ldd r24,Y+17
	/* Overwrite the return address with r18 and r19, to pop it later. icky. */
	std Y+16,r19
	std Y+17,r18
	/* The address saved by the call in the vector table is (vector + 1) * _VECTOR_SIZE */
	/* we get the vector by calculating addr / (_VECTOR_SIZE / 2) - 1 */
#if _VECTOR_SIZE == 4
#if NR_IRQS > 126
	lsr r25
	ror r24
#else
	lsr r24
#endif
#endif
	dec r24
	XCALL do_IRQ
/* epilogue start */
	pop r29
	pop r28
	pop r31
	pop r30
	pop r27
	pop r26
	pop r25
	pop r24
	pop r23
	pop r22
	pop r21
	pop r20
	pop r0
	out __SREG__,r0
	pop r0
	pop r1
	pop r19
	pop r18
	reti
	.size	__irqentry, .-__irqentry
#endif