/* SPDX-License-Identifier: GPL-2.0 */

#ifndef _ASM_AVR_SYSTEM_H
#define _ASM_AVR_SYSTEM_H

#include <asm/io.h>

typedef unsigned char irqflags_t;

#define local_irq_disable()     __asm__ __volatile__("cli": : :"memory")
#define local_irq_enable()      __asm__ __volatile__("sei": : :"memory")

#define local_save_flags(x)  do { x = in(SREG); } while(0)
#define local_irq_save(x)    do { x = in(SREG); local_irq_disable(); } while(0)
#define local_irq_restore(x) do { out(SREG, x); } while(0)

#define irqs_disabled_flags(flags) (!(flags & SREG_I))
#define irqs_disabled()            (!(in(SREG) & SREG_I))

#define set_sleep_mode(sm)  out(MCUCR, in(MCUCR) | sm)

#define do_sleep() do { \
	out(MCUCR, in(MCUCR) | MCUCR_SE); \
	asm volatile("sleep"); \
	out(MCUCR, in(MCUCR) & ~MCUCR_SE); \
} while(0);

#ifdef CONFIG_WAKE_SEMA_FROM_IRQ	

#define safe_halt()    do { \
	local_irq_enable(); \
	set_sleep_mode(MCUCR_SM_IDLE); \
	do_sleep(); \
} while(0)

#else

#define safe_halt()           do { \
	local_irq_enable(); \
	for(;;) { \
		set_sleep_mode(MCUCR_SM_IDLE); \
		do_sleep(); \
	} \
} while(0)

#endif

#endif /* __ASM_SYSTEM_H__ */
